#include <afxwin.h>
#include <struct.h>
#include <3dengine.h>
#include "pagehighlight.h"
#include "../resource.h"


BEGIN_MESSAGE_MAP(CHighLightPage, CPropertyPage)
  ON_LBN_SELCHANGE(IDC_HIGHLIGHTLIST, OnSelChange)
  
  ON_BN_CLICKED(IDC_COLORBUTTON,    OnChooseColor)
  ON_BN_CLICKED(IDC_HIGHLIGHTINVIEWS, OnViewsHighlight)
  ON_BN_CLICKED(IDC_HIGHLIGHTIN3DVIEW,On3DHighlight)
  ON_BN_CLICKED(IDC_HIGHLIGHT3DADD,  On3DAdditive)
  ON_BN_CLICKED(IDC_HIGHLIGHT3DEXTRA,  On3DExtra)
  ON_BN_CLICKED(IDC_HIGHLIGHTCUSTOMCOLOR,  OnCustomColor)
  
  ON_WM_HSCROLL()
END_MESSAGE_MAP()


CHighLightPage::CHighLightPage()
{
  pHighlights = new DWORD[5];
  pD3D = CurrentState.CurrentParams.pD3D;
  pHighlights[0] = pD3D->ActiveHighlight;
  pHighlights[1] = pD3D->SelectedHighlight;
  pHighlights[2] = pD3D->SelActiveHighlight;
  pHighlights[3] = pD3D->NormalsHighlight;
  pHighlights[4] = pD3D->DotsHighlight;
}

CHighLightPage::~CHighLightPage()
{
  if (pHighlights) delete[] pHighlights;
}

BOOL CHighLightPage::OnInitDialog()
{
  pList  =    (CListBox*)GetDlgItem(IDC_HIGHLIGHTLIST);
  pColorButton =  (CButton*)GetDlgItem(IDC_COLORBUTTON);
  pViewsCheck  =  (CButton*)GetDlgItem(IDC_HIGHLIGHTINVIEWS);
  p3DViewCheck=  (CButton*)GetDlgItem(IDC_HIGHLIGHTIN3DVIEW);
  p3DViewAdd  =  (CButton*)GetDlgItem(IDC_HIGHLIGHT3DADD);
  p3DViewExtra=  (CButton*)GetDlgItem(IDC_HIGHLIGHT3DEXTRA);
  p3DCustomColor=  (CButton*)GetDlgItem(IDC_HIGHLIGHTCUSTOMCOLOR);
  pSlider  =    (CSliderCtrl*)GetDlgItem(IDC_TRANSPARENCYSLIDER);
  pSlider->SetRange(0,7);


  CWnd*  pwnd = GetDlgItem(IDC_COLORRECT);
  pwnd->GetClientRect(&RaintRect);
  ColorSampleBar.Create(NULL,
    WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
    RaintRect, pwnd);
  ColorSampleBar.SetProperties(RaintRect, 255,255,255);
  
  //add items to the list;
  pList->AddString("Active (Marked)");
  pList->AddString("Selected");
  pList->AddString("Selected and Active");
  pList->AddString("Normals (normals vectors)");
  pList->AddString("Dots (Vertices and dots in faces)");

  pList->SetItemData(0, pHighlights[0]);
  pList->SetItemData(1, pHighlights[1]);
  pList->SetItemData(2, pHighlights[2]);
  pList->SetItemData(3, pHighlights[3]);
  pList->SetItemData(4, pHighlights[4]);

  CurrentState.CurrentParams.sysp(
      Z3D_REQUEST_LOCALIZE_USER_DIALOG, NULL, "ZModeler\\Settings\\Highlight Page", this, NULL);
  pList->SetCurSel(0);
  OnSelChange();
  return TRUE;
}

afx_msg void CHighLightPage::OnHScroll( UINT nSBCode, UINT nPos, CScrollBar* pScrollBar )
{
  DWORD pos = 0;
  int listpos = pList->GetCurSel();
  if ((CSliderCtrl*)pScrollBar == pSlider)
    pos = pSlider->GetPos();
  pHighlights[listpos] &= ~(Bit25|Bit26|Bit27);
  pHighlights[listpos] |= pos << 24;
  SetModified(TRUE);
}

afx_msg void CHighLightPage::OnSelChange()
{
  DWORD data = pHighlights[pList->GetCurSel()];
  COLORREF col = data & 0xFFFFFF;
  pColorButton->EnableWindow((data & CustomColor) ? TRUE:FALSE);
  pViewsCheck->SetCheck((data & UseInViews) ? 1:0);

  p3DViewCheck->SetCheck((data & UseIn3DView) ? 1:0);
  p3DViewAdd->SetCheck((data & AdditiveHighLight) ? 1:0);
  p3DViewExtra->SetCheck((data & ExtraHighLight) ? 1:0);

  p3DViewAdd->EnableWindow((data & UseIn3DView) ? TRUE:FALSE);
  p3DViewExtra->EnableWindow(((data & UseIn3DView) && (data & AdditiveHighLight)) ? TRUE:FALSE);
  p3DCustomColor->SetCheck((data & CustomColor) ? 1:0);

  pSlider->SetPos((data & (Bit25 | Bit26 | Bit27)) >> 24);

  ColorSampleBar.SetColor((BYTE)(col & 0xff), (BYTE)((col & 0xff00)>>8), (BYTE)((col & 0xff0000)>>16));
  CurrentState.CurrentParams.sysp(
      Z3D_REQUEST_LOCALIZE_USER_DIALOG, NULL, "ZModeler\\Settings\\Highlight Page", this, NULL);
  SetModified(TRUE);
}


afx_msg void CHighLightPage::OnChooseColor()
{
  DWORD data = pHighlights[pList->GetCurSel()];
  COLORREF col = data & 0xFFFFFF;
  CColorDialog cdiag(col, CC_RGBINIT | CC_FULLOPEN, this);
  if (cdiag.DoModal()==IDOK)
  {
    col = cdiag.GetColor();
    pHighlights[pList->GetCurSel()] = (data & 0xFF000000) | (col & 0xFFFFFF);
    ColorSampleBar.SetColor((BYTE)(col & 0xff), (BYTE)((col & 0xff00)>>8), (BYTE)((col & 0xff0000)>>16));
    SetModified(TRUE);
  }
}

afx_msg void CHighLightPage::OnViewsHighlight()
{
  BOOL Checked = (pViewsCheck->GetCheck() == 1);
  DWORD data = pHighlights[pList->GetCurSel()];
  data &= ~UseInViews;
  if (Checked) data |= UseInViews;
  pHighlights[pList->GetCurSel()] = data;
  SetModified(TRUE);
}

afx_msg void CHighLightPage::On3DHighlight()
{
  BOOL Checked = (p3DViewCheck->GetCheck() == 1);
  p3DViewAdd->EnableWindow(Checked);
  p3DViewExtra->EnableWindow(Checked);
  DWORD data = pHighlights[pList->GetCurSel()];
  data &= ~UseIn3DView;
  if (Checked) data |= UseIn3DView;
  pHighlights[pList->GetCurSel()] = data;
  SetModified(TRUE);
}

afx_msg void CHighLightPage::On3DAdditive()
{
  BOOL Checked = (p3DViewAdd->GetCheck() == 1);
  p3DViewExtra->EnableWindow(Checked);
  DWORD data = pHighlights[pList->GetCurSel()];
  data &= ~AdditiveHighLight;
  if (Checked) data |= AdditiveHighLight;
  pHighlights[pList->GetCurSel()] = data;
  SetModified(TRUE);
}

afx_msg void CHighLightPage::On3DExtra()
{
  BOOL Checked = (p3DViewExtra->GetCheck() == 1);
  DWORD data = pHighlights[pList->GetCurSel()];
  data &= ~ExtraHighLight;
  if (Checked) data |= ExtraHighLight;
  pHighlights[pList->GetCurSel()] = data;
  SetModified(TRUE);
}

afx_msg void CHighLightPage::OnCustomColor()
{
  BOOL Checked = (p3DCustomColor->GetCheck() == 1);
  DWORD data = pHighlights[pList->GetCurSel()];
  data &= ~CustomColor;
  if (Checked) data |= CustomColor;
  pHighlights[pList->GetCurSel()] = data;
  pColorButton->EnableWindow(Checked);
  SetModified(TRUE);
}

BOOL CHighLightPage::OnApply()
{
  //////////////////////////////
  //  Highlight Page
  pD3D->ActiveHighlight  = pHighlights[0];
  pD3D->SelectedHighlight  = pHighlights[1];
  pD3D->SelActiveHighlight= pHighlights[2];
  pD3D->NormalsHighlight  = pHighlights[3];
  pD3D->DotsHighlight    = pHighlights[4];

  long request = Z3D_PLUGRESULT_REDRAW;
  CurrentState.CurrentParams.sysp(Z3D_REQUEST_UPDATEMENT, NULL, NULL, &request, NULL);

  return TRUE;
}